#include "MTStringEditor.h"
#include "MTSimpleResource.h"

MTStringEditor::MTStringEditor()
{
	variant = 0;
	value[0] = 0;
}

MTStringEditor::~MTStringEditor()
{
	
}

void MTStringEditor::ReadEditorData(void)
{
	std::memcpy(value, basePtr, (variant >> kTypeDataArea2Shift) & kTypeDataArea2ShiftMask);
}

void MTStringEditor::WriteEditorData(void)
{
	Str255	theString;
	
	ReadTextBox(theString);
	CopyPascalStringToC(theString, value);
	
	value[((variant >> kTypeDataArea2Shift) & kTypeDataArea2ShiftMask) - 1] = 0;
	
	std::memcpy(basePtr, value, (variant >> kTypeDataArea2Shift) & kTypeDataArea2ShiftMask);
}

void MTStringEditor::GetOriginalText(StringPtr text)
{
	value[((variant >> kTypeDataArea2Shift) & kTypeDataArea2ShiftMask) - 1] = 0;
	
	CopyCStringToPascal(value, text);
}